/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.data.tcon;

import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.recipe.data.ICommonRecipeHelper;
import slimeknights.mantle.registration.object.FlowingFluidObject;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.mantle.registration.object.IdAwareObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.recipe.IByproduct;
import slimeknights.tconstruct.library.data.recipe.ISmelteryRecipeHelper;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeBuilder;
import slimeknights.tconstruct.smeltery.data.Byproduct;
import tcintegrations.common.TagManager;
import tcintegrations.data.integration.ModIntegration;
import tcintegrations.data.tcon.SmelteryCompat;
import tcintegrations.data.tcon.material.MaterialIds;
import tcintegrations.items.TCIntegrationsItems;
import tcintegrations.util.ResourceLocationHelper;

public class SmelteryRecipeProvider
extends RecipeProvider
implements ISmelteryRecipeHelper,
ICommonRecipeHelper,
IConditionBuilder {
    public SmelteryRecipeProvider(DataGenerator generator) {
        super(generator);
    }

    public String m_6055_() {
        return "TCIntegrations - TCon Smeltery Recipes";
    }

    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        this.addMeltingRecipes(consumer);
        this.addCastingRecipes(consumer);
        this.addAlloyRecipes(consumer);
    }

    public String getModId() {
        return "tcintegrations";
    }

    private void addCastingRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "smeltery/casting/";
        String metalFolder = folder + "metal/";
        HashMap<String, Consumer> modConsumers = new HashMap<String, Consumer>();
        Consumer arsConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("ars_nouveau")});
        Consumer bygConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("byg")});
        Consumer undergardenConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("undergarden")});
        modConsumers.put("botania", this.withCondition(consumer, new ICondition[]{this.modLoaded("botania")}));
        modConsumers.put("aquaculture", this.withCondition(consumer, new ICondition[]{this.modLoaded("aquaculture")}));
        modConsumers.put("malum", this.withCondition(consumer, new ICondition[]{this.modLoaded("malum")}));
        modConsumers.put("undergarden", undergardenConsumer);
        modConsumers.put("byg", bygConsumer);
        modConsumers.put(MaterialIds.desh.m_135815_(), this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/" + MaterialIds.desh.m_135815_())}));
        modConsumers.put(MaterialIds.calorite.m_135815_(), this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/" + MaterialIds.calorite.m_135815_())}));
        modConsumers.put(MaterialIds.ostrum.m_135815_(), this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/" + MaterialIds.ostrum.m_135815_())}));
        modConsumers.put("iceandfire", this.withCondition(consumer, new ICondition[]{this.modLoaded("iceandfire")}));
        this.gemCasting(arsConsumer, (FluidObject)TCIntegrationsItems.MOLTEN_SOURCE_GEM, (ItemLike)ModIntegration.SOURCE_GEM, folder + "source_gem/gem");
        ItemCastingRecipeBuilder.basinRecipe((ItemLike)ModIntegration.SOURCE_GEM_BLOCK).setFluidAndTime(TCIntegrationsItems.MOLTEN_SOURCE_GEM, false, 400).save(arsConsumer, this.prefix((IdAwareObject)TCIntegrationsItems.MOLTEN_SOURCE_GEM, folder + "source_gem/block"));
        this.ingotCasting(bygConsumer, (FluidObject)TCIntegrationsItems.MOLTEN_PENDORITE, false, (ItemLike)ModIntegration.PENDORITE_SCRAPS, metalFolder + "pendorite/scrap");
        this.metalCasting(bygConsumer, (FluidObject)TCIntegrationsItems.MOLTEN_PENDORITE_ALLOY, false, (ItemLike)ModIntegration.PENDORITE_BLOCK, (ItemLike)ModIntegration.PENDORITE_INGOT, null, metalFolder, "pendorite_alloy/block");
        this.metalCasting(undergardenConsumer, (FluidObject)TCIntegrationsItems.MOLTEN_FORGOTTEN, false, (ItemLike)ModIntegration.FORGOTTEN_BLOCK, (ItemLike)ModIntegration.FORGOTTEN_INGOT, (ItemLike)ModIntegration.FORGOTTEN_NUGGET, metalFolder, "forgotten/block");
        for (SmelteryCompat compat : SmelteryCompat.values()) {
            this.metalTagCasting((Consumer)modConsumers.get(compat.getIdentifier()), compat.getFluid(), compat.getName(), metalFolder, false);
        }
    }

    private void addMeltingRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "smeltery/melting/";
        String metalFolder = folder + "metal/";
        Consumer botaniaConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("botania")});
        Consumer aquacultureConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("aquaculture")});
        Consumer malumConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("malum")});
        Consumer undergardenConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("undergarden")});
        Consumer deshConsumer = this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/" + MaterialIds.desh.m_135815_())});
        Consumer caloriteConsumer = this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/" + MaterialIds.calorite.m_135815_())});
        Consumer ostrumConsumer = this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/" + MaterialIds.ostrum.m_135815_())});
        Consumer bygConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("byg")});
        Consumer ifdConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("iceandfire")});
        Consumer arsConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("ars_nouveau")});
        this.addMetal(botaniaConsumer, TCIntegrationsItems.MOLTEN_MANASTEEL, false, metalFolder, false, Byproduct.IRON);
        this.addMetal(aquacultureConsumer, TCIntegrationsItems.MOLTEN_NEPTUNIUM, false, metalFolder, false, null);
        this.addMetal(malumConsumer, TCIntegrationsItems.MOLTEN_SOUL_STAINED_STEEL, false, metalFolder, false, Byproduct.IRON);
        this.addMetal(undergardenConsumer, TCIntegrationsItems.MOLTEN_CLOGGRUM, true, metalFolder, false, null);
        this.addMetal(undergardenConsumer, TCIntegrationsItems.MOLTEN_FROSTSTEEL, true, metalFolder, false, null);
        this.addMetal(undergardenConsumer, TCIntegrationsItems.MOLTEN_FORGOTTEN, false, metalFolder, false, null);
        this.addMetal(deshConsumer, TCIntegrationsItems.MOLTEN_DESH, true, metalFolder, false, null);
        this.addMetal(caloriteConsumer, TCIntegrationsItems.MOLTEN_CALORITE, true, metalFolder, false, null);
        this.addMetal(ostrumConsumer, TCIntegrationsItems.MOLTEN_OSTRUM, true, metalFolder, false, null);
        this.addMetal(ifdConsumer, TCIntegrationsItems.MOLTEN_DRAGONSTEEL_FIRE, false, metalFolder, false, Byproduct.IRON);
        this.addMetal(ifdConsumer, TCIntegrationsItems.MOLTEN_DRAGONSTEEL_ICE, false, metalFolder, false, Byproduct.IRON);
        this.addMetal(ifdConsumer, TCIntegrationsItems.MOLTEN_DRAGONSTEEL_LIGHTNING, false, metalFolder, false, Byproduct.IRON);
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_(TagManager.Items.EMERALDITE_SHARDS), (Fluid)TinkerFluids.moltenEmerald.get(), (int)25, (float)1.0f).save(bygConsumer, this.location("emeraldite/shard"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_(TagManager.Items.EMERALDITE_ORE), (Fluid)TinkerFluids.moltenEmerald.get(), (int)25, (float)1.0f).save(bygConsumer, this.location("emeraldite/ore"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.PENDORITE_ORE}), (Fluid)TCIntegrationsItems.MOLTEN_PENDORITE.get(), (int)90, (float)2.0f).save(bygConsumer, this.location(metalFolder + "pendorite/ore"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.RAW_PENDORITE}), (Fluid)TCIntegrationsItems.MOLTEN_PENDORITE.get(), (int)90, (float)2.0f).save(bygConsumer, this.location(metalFolder + "pendorite/raw"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.RAW_PENDORITE_BLOCK}), (Fluid)TCIntegrationsItems.MOLTEN_PENDORITE.get(), (int)810, (float)2.0f).save(bygConsumer, this.location(metalFolder + "pendorite/raw_block"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.PENDORITE_SCRAPS}), (Fluid)TCIntegrationsItems.MOLTEN_PENDORITE.get(), (int)90, (float)2.0f).save(bygConsumer, this.location(metalFolder + "pendorite/scrap"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.PENDORITE_INGOT}), (Fluid)TCIntegrationsItems.MOLTEN_PENDORITE_ALLOY.get(), (int)90, (float)2.0f).save(bygConsumer, this.location(metalFolder + "pendorite_alloy/ingot"));
        this.gemMelting(arsConsumer, TCIntegrationsItems.MOLTEN_SOURCE_GEM.get(), "source_gem", false, 4, folder, false, new IByproduct[0]);
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_SILVER_METAL_HELMET}), (Fluid)TinkerFluids.moltenSilver.get(), (int)450).setDamagable(new int[]{10}).save(consumer, this.location(metalFolder + "silver/helmet"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_SILVER_METAL_CHESTPLATE}), (Fluid)TinkerFluids.moltenSilver.get(), (int)720).setDamagable(new int[]{10}).save(consumer, this.location(metalFolder + "silver/chestplate"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_SILVER_METAL_LEGGINGS}), (Fluid)TinkerFluids.moltenSilver.get(), (int)630).setDamagable(new int[]{10}).save(consumer, this.location(metalFolder + "silver/leggings"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_SILVER_METAL_BOOTS}), (Fluid)TinkerFluids.moltenSilver.get(), (int)360).setDamagable(new int[]{10}).save(consumer, this.location(metalFolder + "silver/boots"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_SILVER_AXE, ModIntegration.IFD_SILVER_PICKAXE}), (Fluid)TinkerFluids.moltenSilver.get(), (int)270).setDamagable(new int[]{10}).save(consumer, this.location(metalFolder + "silver/axes"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_SILVER_SWORD, ModIntegration.IFD_SILVER_HOE}), (Fluid)TinkerFluids.moltenSilver.get(), (int)180).setDamagable(new int[]{10}).save(consumer, this.location(metalFolder + "silver/weapon"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_SILVER_SHOVEL}), (Fluid)TinkerFluids.moltenSilver.get(), (int)90).setDamagable(new int[]{10}).save(consumer, this.location(metalFolder + "silver/small"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_DRAGONARMOR_SILVER_HEAD, ModIntegration.IFD_DRAGONARMOR_SILVER_NECK}), (Fluid)TinkerFluids.moltenSilver.get(), (int)4050).setDamagable(new int[]{10}).save(consumer, this.location(metalFolder + "silver/dragon_armor_head_neck"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_DRAGONARMOR_SILVER_BODY}), (Fluid)TinkerFluids.moltenSilver.get(), (int)6480).setDamagable(new int[]{10}).save(consumer, this.location(metalFolder + "silver/dragon_armor_head_body"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_DRAGONARMOR_SILVER_TAIL}), (Fluid)TinkerFluids.moltenSilver.get(), (int)2430).setDamagable(new int[]{10}).save(consumer, this.location(metalFolder + "silver/dragon_armor_head_tail"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_COPPER_METAL_HELMET}), (Fluid)TinkerFluids.moltenCopper.get(), (int)450).setDamagable(new int[]{10}).save(consumer, this.location(metalFolder + "copper/helmet"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_COPPER_METAL_CHESTPLATE}), (Fluid)TinkerFluids.moltenCopper.get(), (int)720).setDamagable(new int[]{10}).save(consumer, this.location(metalFolder + "copper/chestplate"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_COPPER_METAL_LEGGINGS}), (Fluid)TinkerFluids.moltenCopper.get(), (int)630).setDamagable(new int[]{10}).save(consumer, this.location(metalFolder + "copper/leggings"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_COPPER_METAL_BOOTS}), (Fluid)TinkerFluids.moltenCopper.get(), (int)360).setDamagable(new int[]{10}).save(consumer, this.location(metalFolder + "copper/boots"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_COPPER_AXE, ModIntegration.IFD_COPPER_PICKAXE}), (Fluid)TinkerFluids.moltenCopper.get(), (int)270).setDamagable(new int[]{10}).save(consumer, this.location(metalFolder + "copper/axes"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_COPPER_SWORD, ModIntegration.IFD_COPPER_HOE}), (Fluid)TinkerFluids.moltenCopper.get(), (int)180).setDamagable(new int[]{10}).save(consumer, this.location(metalFolder + "copper/weapon"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_COPPER_SHOVEL}), (Fluid)TinkerFluids.moltenCopper.get(), (int)90).setDamagable(new int[]{10}).save(consumer, this.location(metalFolder + "copper/small"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_DRAGONARMOR_COPPER_HEAD, ModIntegration.IFD_DRAGONARMOR_COPPER_NECK}), (Fluid)TinkerFluids.moltenCopper.get(), (int)4050).setDamagable(new int[]{10}).save(consumer, this.location(metalFolder + "copper/dragon_armor_head_neck"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_DRAGONARMOR_COPPER_BODY}), (Fluid)TinkerFluids.moltenCopper.get(), (int)6480).setDamagable(new int[]{10}).save(consumer, this.location(metalFolder + "copper/dragon_armor_head_body"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModIntegration.IFD_DRAGONARMOR_COPPER_TAIL}), (Fluid)TinkerFluids.moltenCopper.get(), (int)2430).setDamagable(new int[]{10}).save(consumer, this.location(metalFolder + "copper/dragon_armor_head_tail"));
    }

    private void addAlloyRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "smeltery/alloys/";
        Consumer bygConsumer = this.withCondition(consumer, new ICondition[]{this.modLoaded("byg")});
        ConditionalRecipe.builder().addCondition((ICondition)new TagEmptyCondition(ResourceLocationHelper.location("forge", "ingots/tin"))).addRecipe(arg_0 -> ((AlloyRecipeBuilder)AlloyRecipeBuilder.alloy((Fluid)TinkerFluids.moltenBronze.get(), (int)360).addInput(TinkerFluids.moltenCopper.getForgeTag(), 270).addInput(TinkerFluids.moltenObsidian.getLocalTag(), 1000)).save(arg_0)).build(consumer, this.prefix((IdAwareObject)TinkerFluids.moltenBronze, folder));
        AlloyRecipeBuilder.alloy((Fluid)TCIntegrationsItems.MOLTEN_PENDORITE_ALLOY.get(), (int)90).addInput(TCIntegrationsItems.MOLTEN_PENDORITE.getForgeTag(), 360).addInput(TinkerFluids.moltenDiamond.getLocalTag(), 200).addInput(TinkerFluids.moltenEmerald.getLocalTag(), 50).save(bygConsumer, this.prefix((IdAwareObject)TCIntegrationsItems.MOLTEN_PENDORITE_ALLOY, folder));
    }

    private void addMetal(Consumer<FinishedRecipe> consumer, FlowingFluidObject<ForgeFlowingFluid> fluid, boolean hasOre, String folder, boolean isOptional, @Nullable Byproduct byproduct) {
        if (byproduct != null) {
            this.metalMelting(consumer, fluid.get(), fluid.getId().m_135815_(), hasOre, folder, isOptional, new IByproduct[]{byproduct});
        } else {
            this.metalMelting(consumer, fluid.get(), fluid.getId().m_135815_(), hasOre, folder, isOptional, new IByproduct[0]);
        }
    }
}

